/*
 * Decompiled with CFR 0.152.
 */
package CaveRender;

import CaveRender.Matrix;
import CaveRender.Position;
import CaveRender.Punkt;
import CaveRender.Spline;
import java.util.Vector;

class Animation {
    public Vector<Position> positionen;
    public int n_Frames = 0;
    public int n_Pos = 0;
    public int n_Animation = 0;
    boolean animation = false;
    Spline splAzimut = new Spline();
    Spline splNeigung = new Spline();
    Spline splAbstand = new Spline();
    Spline splX = new Spline();
    Spline splY = new Spline();
    Spline splZ = new Spline();
    public int time = 20;
    public int frames = 25;
    public double zoom = 100.0;
    public boolean repeat = true;
    public int startpos;
    public Position viewpos;
    public Position animpos;
    public String modus = "Auto";
    public int Pitch = 0;

    public Animation() {
        this.positionen = new Vector(10, 10);
        this.viewpos = new Position();
        this.animpos = new Position();
    }

    public void Init() {
        this.positionen.removeAllElements();
        this.n_Frames = 0;
        this.n_Pos = 0;
        this.n_Animation = 0;
        this.animation = false;
        this.time = 20;
        this.frames = 25;
        this.zoom = 100.0;
        this.repeat = true;
        this.viewpos = new Position();
        this.animpos = new Position();
        this.modus = "Auto";
        this.Pitch = 0;
    }

    public void Add(Position p) {
        this.positionen.addElement(p);
    }

    public void Viewpos(Position p) {
        this.viewpos = new Position(p);
    }

    public void Start() {
        this.animation = true;
    }

    public void Stop() {
        this.animation = false;
    }

    public boolean Berechnen(int Bilder, boolean Endlos) {
        double LastAzimut = 0.0;
        double OffsetAzimut = 0.0;
        double[] dFrames = new double[257];
        double[] dAzimut = new double[257];
        double[] dNeigung = new double[257];
        double[] dAbstand = new double[257];
        double[] dX = new double[257];
        double[] dY = new double[257];
        double[] dZ = new double[257];
        this.n_Frames = 0;
        this.n_Pos = 0;
        this.n_Animation = 0;
        if (Endlos && this.positionen.size() <= 1 || !Endlos && this.positionen.size() <= 2) {
            System.out.println("Zu wenig Animationspositionen");
            return false;
        }
        int i = 0;
        while (i < this.positionen.size()) {
            Position pView = this.positionen.elementAt(i);
            if (i >= 1) {
                if (LastAzimut >= 180.0 && LastAzimut - pView.Azimut >= 180.0) {
                    OffsetAzimut += 360.0;
                }
                if (LastAzimut < 180.0 && pView.Azimut - LastAzimut >= 180.0) {
                    OffsetAzimut -= 360.0;
                }
            }
            dFrames[this.n_Pos] = this.n_Frames;
            this.n_Frames += Bilder;
            dAzimut[this.n_Pos] = OffsetAzimut + pView.Azimut;
            dNeigung[this.n_Pos] = pView.Neigung;
            dAbstand[this.n_Pos] = pView.Abstand;
            dX[this.n_Pos] = pView.Zentrum.x;
            dY[this.n_Pos] = pView.Zentrum.y;
            dZ[this.n_Pos] = pView.Zentrum.z;
            LastAzimut = pView.Azimut;
            ++this.n_Pos;
            ++i;
        }
        if (Endlos) {
            if (LastAzimut >= 180.0 && LastAzimut - dAzimut[0] >= 180.0) {
                OffsetAzimut += 360.0;
            }
            if (LastAzimut < 180.0 && dAzimut[0] - LastAzimut >= 180.0) {
                OffsetAzimut -= 360.0;
            }
            dFrames[this.n_Pos] = this.n_Frames;
            dAzimut[this.n_Pos] = OffsetAzimut + dAzimut[0];
            dNeigung[this.n_Pos] = dNeigung[0];
            dAbstand[this.n_Pos] = dAbstand[0];
            dX[this.n_Pos] = dX[0];
            dY[this.n_Pos] = dY[0];
            dZ[this.n_Pos] = dZ[0];
            ++this.n_Pos;
        } else {
            this.n_Frames -= Bilder;
        }
        this.splAzimut.Create(this.n_Pos, Endlos);
        this.splNeigung.Create(this.n_Pos, Endlos);
        this.splAbstand.Create(this.n_Pos, Endlos);
        this.splX.Create(this.n_Pos, Endlos);
        this.splY.Create(this.n_Pos, Endlos);
        this.splZ.Create(this.n_Pos, Endlos);
        this.splAzimut.SetBases(dFrames, dAzimut);
        this.splNeigung.SetBases(dFrames, dNeigung);
        this.splAbstand.SetBases(dFrames, dAbstand);
        this.splX.SetBases(dFrames, dX);
        this.splY.SetBases(dFrames, dY);
        this.splZ.SetBases(dFrames, dZ);
        return true;
    }

    public Matrix NaechstesBild(boolean Endlos, double Diameter, double Zoom) {
        Punkt Zentrum = new Punkt();
        Matrix m = null;
        if (this.modus.equals("Maus")) {
            return null;
        }
        if (this.modus.equals("Pitch")) {
            this.viewpos.Azimut += (double)this.Pitch;
            while (this.viewpos.Azimut < 0.0) {
                this.viewpos.Azimut += 360.0;
            }
            while (this.viewpos.Azimut >= 360.0) {
                this.viewpos.Azimut -= 360.0;
            }
            m = this.MatrixAnimation(this.viewpos.Azimut, this.viewpos.Neigung, this.viewpos.Abstand, Diameter, this.viewpos.Zentrum, Zoom);
            return m;
        }
        if (this.modus.equals("Move")) {
            m = this.MatrixAnimation(this.viewpos.Azimut, this.viewpos.Neigung, this.viewpos.Abstand, Diameter, this.viewpos.Zentrum, Zoom);
            this.modus = "Maus";
            return m;
        }
        if (!this.animation) {
            return null;
        }
        if (this.n_Animation < this.n_Frames || !Endlos && this.n_Animation <= this.n_Frames) {
            double Azimut = this.splAzimut.GetValue(this.n_Animation);
            while (Azimut >= 360.0) {
                Azimut -= 360.0;
            }
            while (Azimut < 0.0) {
                Azimut += 360.0;
            }
            double Neigung = this.splNeigung.GetValue(this.n_Animation);
            double Abstand = this.splAbstand.GetValue(this.n_Animation);
            Zentrum.x = this.splX.GetValue(this.n_Animation);
            Zentrum.y = this.splY.GetValue(this.n_Animation);
            Zentrum.z = this.splZ.GetValue(this.n_Animation);
            ++this.n_Animation;
            m = this.MatrixAnimation(Azimut, Neigung, Abstand, Diameter, Zentrum, Zoom);
            this.animpos.Set(Azimut, Neigung, Abstand, Zentrum);
        }
        if (Endlos && this.n_Animation == this.n_Frames) {
            this.n_Animation = 0;
        }
        if (!Endlos && this.n_Animation == this.n_Frames + 1) {
            if (this.modus.equals("Auto")) {
                this.modus = "Maus";
                this.MausPositionSetzen();
            } else {
                m = null;
            }
        }
        if (this.modus == "Springe") {
            this.modus = "Maus";
            this.MausPositionSetzen();
        }
        return m;
    }

    public void MausPositionSetzen() {
        this.viewpos.Set(this.animpos);
    }

    public Matrix MatrixAnimation(double azim, double inc, double dist, double diameter, Punkt p0, double zoom) {
        double pi_180 = Math.PI / 180;
        double Offset = 500.0;
        double Fake = 1000.0;
        Matrix tmatrix = new Matrix();
        Matrix matrix = new Matrix();
        tmatrix.Clear();
        matrix.Clear();
        matrix.m[0][0] = zoom / 100.0;
        matrix.m[1][1] = zoom / 100.0;
        matrix.m[2][2] = zoom / 100.0;
        tmatrix.Mult(matrix);
        matrix.Clear();
        matrix.m[2][3] = 0.002;
        tmatrix.Mult(matrix);
        matrix.Clear();
        double FakeScale = 1000.0 / diameter;
        matrix.m[3][2] = FakeScale * dist + 500.0;
        tmatrix.Mult(matrix);
        matrix.Clear();
        matrix.m[1][1] = Math.cos(inc * (Math.PI / 180));
        matrix.m[1][2] = Math.sin(inc * (Math.PI / 180));
        matrix.m[2][1] = -Math.sin(inc * (Math.PI / 180));
        matrix.m[2][2] = Math.cos(inc * (Math.PI / 180));
        tmatrix.Mult(matrix);
        matrix.Clear();
        matrix.m[2][2] = Math.cos(azim * (Math.PI / 180));
        matrix.m[2][0] = -Math.sin(azim * (Math.PI / 180));
        matrix.m[0][2] = Math.sin(azim * (Math.PI / 180));
        matrix.m[0][0] = Math.cos(azim * (Math.PI / 180));
        tmatrix.Mult(matrix);
        matrix.Clear();
        matrix.m[1][1] = 0.0;
        matrix.m[2][2] = 0.0;
        matrix.m[1][2] = 1.0;
        matrix.m[2][1] = 1.0;
        tmatrix.Mult(matrix);
        matrix.Clear();
        matrix.m[0][0] = FakeScale;
        matrix.m[1][1] = FakeScale;
        matrix.m[2][2] = FakeScale;
        tmatrix.Mult(matrix);
        matrix.Clear();
        matrix.m[3][0] = -p0.x;
        matrix.m[3][1] = -p0.y;
        matrix.m[3][2] = -p0.z;
        tmatrix.Mult(matrix);
        return tmatrix;
    }
}

