/*
 * Decompiled with CFR 0.152.
 */
package CaveRender;

import CaveRender.Animation;
import CaveRender.Ausgabe;
import CaveRender.Eingabe;
import CaveRender.Farben;
import CaveRender.Hoehle;
import CaveRender.Matrix;
import CaveRender.Position;
import java.applet.AppletContext;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.InputStream;
import java.net.URL;

class AnimationPanel
extends Panel
implements Runnable,
MouseListener,
MouseWheelListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    Ausgabe display = new Ausgabe();
    Farben colors = new Farben();
    Hoehle cave = new Hoehle();
    Animation anim = new Animation();
    Eingabe file = new Eingabe();
    Image offscreen;
    Dimension offscreensize;
    Graphics offgraphics;
    Thread animator;
    String errmsg = "";
    String msg = "";
    String wellcome1 = "JavaCaveRender";
    String wellcome2 = "Version 5.3  (c) 2000-2015";
    String wellcome3 = "www.caverender.de/java";
    boolean DatenLesen = true;
    int startx;
    int starty;
    String KeyModus = "";
    Position rotatestart;
    public URL Parameter_URL = null;
    public String Parameter_Datei = null;
    public String Parameter_Modus = null;
    public String Parameter_Endlos = null;
    public String Parameter_Zoom = null;
    public String Parameter_Bilder = null;
    public String Parameter_Zeit = null;
    public String Parameter_Text = null;
    public String Parameter_Winkel = null;
    public AppletContext Parameter_AppletContext = null;

    AnimationPanel() {
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    @Override
    public synchronized void update(Graphics g) {
        Dimension d = this.getSize();
        if (!this.wellcome1.equals("")) {
            this.display.Wellcome(g, d.width, d.height, this.wellcome1, this.wellcome2, this.wellcome3);
            this.wellcome3 = "";
            this.wellcome2 = "";
            this.wellcome1 = "";
        } else if (!this.msg.equals("") || !this.errmsg.equals("")) {
            this.display.Message(g, d.width, d.height, this.msg, this.errmsg);
            this.errmsg = "";
            this.msg = "";
        } else {
            if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
                this.offscreen = this.createImage(d.width, d.height);
                this.offscreensize = d;
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setFont(this.getFont());
            }
            this.display.Paint(this.offgraphics, this.getSize().width, this.getSize().height, this.cave, this.colors);
            g.drawImage(this.offscreen, 0, 0, null);
        }
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        this.requestFocus();
        while (this.animator == me) {
            if (this.DatenLesen) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.repaint();
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.Parameter_Datei == null) {
                    this.msg = "Keine Datei angegeben.";
                    this.repaint();
                    return;
                }
                if (!this.Parameter_Datei.endsWith(".jcr")) {
                    this.msg = "Keine JCR-Datei: " + this.Parameter_Datei;
                    this.repaint();
                    return;
                }
                InputStream is = null;
                try {
                    is = this.Parameter_URL.openStream();
                    if (!this.file.DateiLesen(is, this.cave, this.anim, this.colors, this.display)) {
                        this.msg = "Fehler in JCR-Dateiformat. Weitere Infos auf der Java-Konsole.";
                        this.repaint();
                        return;
                    }
                }
                catch (Exception e) {
                    this.msg = "JCR-Datei " + this.Parameter_Datei + " kann nicht ge\u00f6ffnet werden.";
                    this.errmsg = e.toString();
                    this.repaint();
                    return;
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    this.msg = "JCR-Datei kann nicht geschlossen werden.";
                    this.errmsg = e.toString();
                    this.repaint();
                    return;
                }
                this.anim.modus = "Auto";
                if (this.Parameter_Modus != null) {
                    this.anim.modus = this.Parameter_Modus;
                }
                if (this.Parameter_Endlos != null) {
                    boolean bl = this.anim.repeat = !this.Parameter_Endlos.equals("0");
                }
                if (this.Parameter_Zoom != null) {
                    this.anim.zoom = Integer.parseInt(this.Parameter_Zoom);
                }
                this.anim.zoom = Math.min(1000.0, Math.max(1.0, this.anim.zoom));
                if (this.Parameter_Bilder != null) {
                    this.anim.frames = Integer.parseInt(this.Parameter_Bilder);
                }
                this.anim.frames = Math.min(1000, Math.max(1, this.anim.frames));
                if (this.Parameter_Zeit != null) {
                    this.anim.time = Integer.parseInt(this.Parameter_Zeit);
                }
                this.anim.time = Math.min(1000, Math.max(1, this.anim.time));
                if (this.Parameter_Text != null) {
                    this.display.text = Integer.parseInt(this.Parameter_Text);
                }
                this.display.text = Math.min(72, Math.max(0, this.display.text));
                if (this.Parameter_Winkel != null) {
                    this.display.rotate = Integer.parseInt(this.Parameter_Winkel);
                }
                this.display.rotate = Math.min(90, Math.max(0, this.display.rotate));
                try {
                    if (!this.anim.Berechnen(this.anim.frames, this.anim.repeat)) {
                        this.anim.modus = "Maus";
                    }
                }
                catch (Exception e) {
                    this.msg = "Fehler beim Berechnen der Animation.";
                    this.errmsg = e.toString();
                    this.repaint();
                    return;
                }
                this.cave.SetDiameter();
                this.DatenLesen = false;
            }
            try {
                Matrix m = this.anim.NaechstesBild(this.anim.repeat, this.cave.GetDiameter(), this.anim.zoom * (double)this.getSize().height / 600.0);
                if (m != null) {
                    this.cave.SetMatrix(m);
                    this.cave.Berechnen();
                    this.repaint();
                }
                Thread.sleep(this.anim.time);
            }
            catch (InterruptedException e) {
                this.msg = "Fehler beim Ausf\u00fchren der Animation.";
                this.errmsg = e.toString();
                this.repaint();
                return;
            }
        }
    }

    public void start() {
        this.animator = new Thread(this);
        this.animator.start();
        this.anim.Start();
    }

    public void stop() {
        this.animator = null;
        this.anim.Stop();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.Parameter_AppletContext != null && this.DatenLesen) {
            try {
                URL u = new URL("http://www.caverender.de/java");
                this.Parameter_AppletContext.showDocument(u, "_blank");
            }
            catch (Exception ex) {
                System.out.println("URL http://www.caverender.de/java nicht erreichbar.");
            }
        }
        if (this.anim.modus.equals("Auto")) {
            this.anim.MausPositionSetzen();
        }
        this.anim.modus = "Maus";
        this.startx = e.getX();
        this.starty = e.getY();
        this.anim.Pitch = 0;
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.anim.modus.equals("Move")) {
            this.anim.modus = "Pitch";
        }
        this.removeMouseMotionListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        double delta = Math.max(this.cave.GetDiameter() / 5.0, this.cave.GetDiameter() + this.anim.viewpos.Abstand) / this.anim.zoom / (double)this.getSize().height * 115.0;
        if (e.getModifiers() == 16) {
            this.anim.viewpos.Azimut += (double)(x - this.startx);
            this.anim.viewpos.Neigung -= (double)(y - this.starty);
            if (this.anim.viewpos.Neigung > 90.0) {
                this.anim.viewpos.Neigung = 90.0;
            }
            if (this.anim.viewpos.Neigung < -90.0) {
                this.anim.viewpos.Neigung = -90.0;
            }
            while (this.anim.viewpos.Azimut < 0.0) {
                this.anim.viewpos.Azimut += 360.0;
            }
            while (this.anim.viewpos.Azimut >= 360.0) {
                this.anim.viewpos.Azimut -= 360.0;
            }
        } else if (e.getModifiers() == 4) {
            double neig = this.anim.viewpos.Neigung * Math.PI / 180.0;
            double azim = this.anim.viewpos.Azimut * Math.PI / 180.0;
            this.anim.viewpos.Zentrum.x -= delta * (double)(x - this.startx) * Math.cos(azim);
            this.anim.viewpos.Zentrum.y += delta * (double)(x - this.startx) * Math.sin(azim);
            this.anim.viewpos.Zentrum.z += delta * (double)(y - this.starty) * Math.cos(neig);
            double horiz = delta * (double)(y - this.starty) * Math.sin(neig);
            this.anim.viewpos.Zentrum.x -= horiz * Math.sin(azim);
            this.anim.viewpos.Zentrum.y -= horiz * Math.cos(azim);
        } else if (e.getModifiers() == 8 || e.getModifiers() == 20) {
            this.anim.viewpos.Abstand -= delta * (double)(y - this.starty);
        }
        this.anim.Pitch = x - this.startx;
        this.startx = x;
        this.starty = y;
        this.anim.modus = "Move";
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.anim.modus.equals("Auto")) {
            this.anim.MausPositionSetzen();
        }
        this.anim.modus = "Move";
        double delta_dist = Math.max(this.cave.GetDiameter() / 5.0, this.cave.GetDiameter() + this.anim.viewpos.Abstand) / this.anim.zoom * 10.0;
        this.anim.viewpos.Abstand -= delta_dist * (double)e.getWheelRotation();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if ((key == 32 || key == 10) && this.anim.modus == "Maus") {
            if (this.anim.n_Animation >= this.anim.n_Frames) {
                this.anim.n_Animation = 0;
            }
            this.anim.modus = "Auto";
            this.KeyModus = "";
            return;
        }
        if (this.anim.modus.equals("Auto")) {
            this.anim.modus = "Maus";
            this.anim.MausPositionSetzen();
        }
        if (key == 16 && this.KeyModus == "") {
            this.KeyModus = "Ums";
        } else if (key == 17 && this.KeyModus == "") {
            this.KeyModus = "Strg";
        } else if (key == 16 && this.KeyModus == "Strg") {
            this.KeyModus = "Ums+Strg";
        } else if (key == 17 && this.KeyModus == "Ums") {
            this.KeyModus = "Ums+Strg";
        }
        if (this.KeyModus == "") {
            int delta_rot = 5;
            if (key == 37) {
                this.anim.viewpos.Azimut -= (double)delta_rot;
                while (this.anim.viewpos.Azimut < 0.0) {
                    this.anim.viewpos.Azimut += 360.0;
                }
                this.anim.modus = "Move";
            } else if (key == 39) {
                this.anim.viewpos.Azimut += (double)delta_rot;
                while (this.anim.viewpos.Azimut >= 360.0) {
                    this.anim.viewpos.Azimut -= 360.0;
                }
                this.anim.modus = "Move";
            } else if (key == 38) {
                this.anim.viewpos.Neigung += (double)delta_rot;
                if (this.anim.viewpos.Neigung > 90.0) {
                    this.anim.viewpos.Neigung = 90.0;
                }
                this.anim.modus = "Move";
            } else if (key == 40) {
                this.anim.viewpos.Neigung -= (double)delta_rot;
                if (this.anim.viewpos.Neigung < -90.0) {
                    this.anim.viewpos.Neigung = -90.0;
                }
                this.anim.modus = "Move";
            }
        } else if (this.KeyModus == "Ums") {
            double delta_trans = Math.max(this.cave.GetDiameter() / 5.0, this.cave.GetDiameter() + this.anim.viewpos.Abstand) / this.anim.zoom * 2.5;
            double x = 0.0;
            double y = 0.0;
            if (key == 37) {
                x = -delta_trans;
            } else if (key == 39) {
                x = delta_trans;
            } else if (key == 38) {
                y = -delta_trans;
            } else if (key == 40) {
                y = delta_trans;
            }
            if (x != 0.0 || y != 0.0) {
                double neig = this.anim.viewpos.Neigung * Math.PI / 180.0;
                double azim = this.anim.viewpos.Azimut * Math.PI / 180.0;
                this.anim.viewpos.Zentrum.x -= x * Math.cos(azim);
                this.anim.viewpos.Zentrum.y += x * Math.sin(azim);
                this.anim.viewpos.Zentrum.z += y * Math.cos(neig);
                double horiz = y * Math.sin(neig);
                this.anim.viewpos.Zentrum.x -= horiz * Math.sin(azim);
                this.anim.viewpos.Zentrum.y -= horiz * Math.cos(azim);
                this.anim.modus = "Move";
            }
        } else if (this.KeyModus == "Strg") {
            double delta_dist = Math.max(this.cave.GetDiameter() / 5.0, this.cave.GetDiameter() + this.anim.viewpos.Abstand) / this.anim.zoom * 10.0;
            if (key == 38) {
                this.anim.viewpos.Abstand += delta_dist;
                this.anim.modus = "Move";
            } else if (key == 40) {
                this.anim.viewpos.Abstand -= delta_dist;
                this.anim.modus = "Move";
            }
        } else if (this.KeyModus == "Ums+Strg") {
            if (key == 37) {
                if (this.anim.repeat && this.anim.n_Animation <= 1) {
                    this.anim.n_Animation = this.anim.n_Frames;
                }
                this.anim.n_Animation = this.anim.frames * (int)Math.max(0.0, Math.floor((double)(this.anim.n_Animation - 2) / (double)this.anim.frames));
                this.anim.modus = "Springe";
            } else if (key == 39) {
                this.anim.n_Animation = Math.min(this.anim.n_Animation, this.anim.n_Frames);
                this.anim.n_Animation = this.anim.frames * (int)Math.min((double)this.anim.n_Frames, Math.ceil((double)this.anim.n_Animation / (double)this.anim.frames));
                if (this.anim.repeat && this.anim.n_Animation == this.anim.n_Frames) {
                    this.anim.n_Animation = 0;
                }
                this.anim.modus = "Springe";
            } else if (key == 36) {
                this.anim.n_Animation = 0;
                this.anim.modus = "Springe";
            } else if (key == 35) {
                this.anim.n_Animation = this.anim.repeat ? this.anim.frames * (int)Math.max(0.0, Math.floor((double)(this.anim.n_Frames - 1) / (double)this.anim.frames)) : this.anim.n_Frames;
                this.anim.modus = "Springe";
            } else if (key == 90) {
                this.anim.viewpos.Zentrum.x = this.cave.GetZentrum().x;
                this.anim.viewpos.Zentrum.y = this.cave.GetZentrum().y;
                this.anim.viewpos.Zentrum.z = this.cave.GetZentrum().z;
                this.anim.viewpos.Abstand = 0.0;
            } else if (key == 65) {
                this.anim.n_Animation = 0;
                this.anim.modus = "Auto";
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 16 && this.KeyModus == "Ums+Strg") {
            this.KeyModus = "Strg";
        } else if (key == 17 && this.KeyModus == "Ums+Strg") {
            this.KeyModus = "Ums";
        } else if (key == 16 && this.KeyModus == "Ums") {
            this.KeyModus = "";
        } else if (key == 17 && this.KeyModus == "Strg") {
            this.KeyModus = "";
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

