/*
 * Decompiled with CFR 0.152.
 */
package CaveRender;

import CaveRender.Linie;
import CaveRender.Punkt;

class Matrix {
    public double[][] m = new double[4][4];

    public Matrix() {
        this.Clear();
    }

    public void Clear() {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.m[i][j] = 0.0;
                ++j;
            }
            this.m[i][i] = 1.0;
            ++i;
        }
    }

    public void Set(int i, int j, double e) {
        if (i < 0 || i > 3 || j < 0 || j > 3) {
            return;
        }
        this.m[i][j] = e;
    }

    public void Set(Matrix m1) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.m[i][j] = m1.m[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void Print() {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                System.out.print(String.valueOf(this.m[i][j]) + " ");
                ++j;
            }
            System.out.println("");
            ++i;
        }
        System.out.println("");
    }

    public void Mult(Matrix ma) {
        int j;
        Matrix mb = this;
        Matrix mc = new Matrix();
        int i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                mc.m[i][j] = ma.m[i][0] * mb.m[0][j] + ma.m[i][1] * mb.m[1][j] + ma.m[i][2] * mb.m[2][j] + ma.m[i][3] * mb.m[3][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                mb.m[i][j] = mc.m[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Punkt MultPunkt(Punkt u) {
        Punkt v = new Punkt();
        v.x = this.m[0][0] * u.x + this.m[1][0] * u.y + this.m[2][0] * u.z + this.m[3][0];
        v.y = this.m[0][1] * u.x + this.m[1][1] * u.y + this.m[2][1] * u.z + this.m[3][1];
        v.z = this.m[0][2] * u.x + this.m[1][2] * u.y + this.m[2][2] * u.z + this.m[3][2];
        double w = this.m[0][3] * u.x + this.m[1][3] * u.y + this.m[2][3] * u.z + this.m[3][3];
        if (w > 0.0) {
            v.x /= w;
            v.y /= w;
        } else {
            v.x = 0.0;
            v.y = 0.0;
            v.z = 0.0;
        }
        return v;
    }

    public void MultLinie(Linie l) {
        this.MultLinie(l.p1, l.p2, l.pdc1, l.pdc2);
    }

    public void MultLinie(Punkt u1, Punkt u2, Punkt v1, Punkt v2) {
        double plane = 0.0;
        double eps = 0.001;
        double box = 1000.0;
        Punkt diff = new Punkt();
        Punkt clip = new Punkt();
        double w1 = this.m[0][3] * u1.x + this.m[1][3] * u1.y + this.m[2][3] * u1.z + this.m[3][3];
        double w2 = this.m[0][3] * u2.x + this.m[1][3] * u2.y + this.m[2][3] * u2.z + this.m[3][3];
        if (w1 > 0.0 && w2 > 0.0) {
            v1.x = this.m[0][0] * u1.x + this.m[1][0] * u1.y + this.m[2][0] * u1.z + this.m[3][0];
            v1.y = this.m[0][1] * u1.x + this.m[1][1] * u1.y + this.m[2][1] * u1.z + this.m[3][1];
            v1.z = this.m[0][2] * u1.x + this.m[1][2] * u1.y + this.m[2][2] * u1.z + this.m[3][2];
            v1.x /= w1;
            v1.y /= w1;
            v2.x = this.m[0][0] * u2.x + this.m[1][0] * u2.y + this.m[2][0] * u2.z + this.m[3][0];
            v2.y = this.m[0][1] * u2.x + this.m[1][1] * u2.y + this.m[2][1] * u2.z + this.m[3][1];
            v2.z = this.m[0][2] * u2.x + this.m[1][2] * u2.y + this.m[2][2] * u2.z + this.m[3][2];
            v2.x /= w2;
            v2.y /= w2;
        } else if (w1 <= 0.0 && w2 <= 0.0) {
            v1.x = 0.0;
            v1.y = 0.0;
            v1.z = -1.0;
            v2.x = 0.0;
            v2.y = 0.0;
            v2.z = -1.0;
        } else if (w1 <= 0.0) {
            diff.x = u2.x - u1.x;
            diff.y = u2.y - u1.y;
            diff.z = u2.z - u1.z;
            clip.x = u1.x;
            clip.y = u1.y;
            clip.z = u1.z;
            while (w1 <= 0.0 || w1 >= 0.001) {
                diff.x /= 2.0;
                diff.y /= 2.0;
                diff.z /= 2.0;
                if (w1 <= 0.0) {
                    clip.x += diff.x;
                    clip.y += diff.y;
                    clip.z += diff.z;
                } else {
                    clip.x -= diff.x;
                    clip.y -= diff.y;
                    clip.z -= diff.z;
                }
                w1 = this.m[0][3] * clip.x + this.m[1][3] * clip.y + this.m[2][3] * clip.z + this.m[3][3];
            }
            v1.x = this.m[0][0] * clip.x + this.m[1][0] * clip.y + this.m[2][0] * clip.z + this.m[3][0];
            v1.y = this.m[0][1] * clip.x + this.m[1][1] * clip.y + this.m[2][1] * clip.z + this.m[3][1];
            v1.z = this.m[0][2] * clip.x + this.m[1][2] * clip.y + this.m[2][2] * clip.z + this.m[3][2];
            v1.x /= w1;
            v1.y /= w1;
            v2.x = this.m[0][0] * u2.x + this.m[1][0] * u2.y + this.m[2][0] * u2.z + this.m[3][0];
            v2.y = this.m[0][1] * u2.x + this.m[1][1] * u2.y + this.m[2][1] * u2.z + this.m[3][1];
            v2.z = this.m[0][2] * u2.x + this.m[1][2] * u2.y + this.m[2][2] * u2.z + this.m[3][2];
            v2.x /= w2;
            v2.y /= w2;
        } else if (w2 <= 0.0) {
            diff.x = u1.x - u2.x;
            diff.y = u1.y - u2.y;
            diff.z = u1.z - u2.z;
            clip.x = u2.x;
            clip.y = u2.y;
            clip.z = u2.z;
            while (w2 <= 0.0 || w2 >= 0.001) {
                diff.x /= 2.0;
                diff.y /= 2.0;
                diff.z /= 2.0;
                if (w2 <= 0.0) {
                    clip.x += diff.x;
                    clip.y += diff.y;
                    clip.z += diff.z;
                } else {
                    clip.x -= diff.x;
                    clip.y -= diff.y;
                    clip.z -= diff.z;
                }
                w2 = this.m[0][3] * clip.x + this.m[1][3] * clip.y + this.m[2][3] * clip.z + this.m[3][3];
            }
            v1.x = this.m[0][0] * u1.x + this.m[1][0] * u1.y + this.m[2][0] * u1.z + this.m[3][0];
            v1.y = this.m[0][1] * u1.x + this.m[1][1] * u1.y + this.m[2][1] * u1.z + this.m[3][1];
            v1.z = this.m[0][2] * u1.x + this.m[1][2] * u1.y + this.m[2][2] * u1.z + this.m[3][2];
            v1.x /= w1;
            v1.y /= w1;
            v2.x = this.m[0][0] * clip.x + this.m[1][0] * clip.y + this.m[2][0] * clip.z + this.m[3][0];
            v2.y = this.m[0][1] * clip.x + this.m[1][1] * clip.y + this.m[2][1] * clip.z + this.m[3][1];
            v2.z = this.m[0][2] * clip.x + this.m[1][2] * clip.y + this.m[2][2] * clip.z + this.m[3][2];
            v2.x /= w2;
            v2.y /= w2;
        }
        if (v1.x < -1000.0) {
            if (v2.x != v1.x) {
                v1.y = (-1000.0 - v1.x) * (v2.y - v1.y) / (v2.x - v1.x) + v1.y;
            }
            v1.x = -1000.0;
        } else if (v1.x > 1000.0) {
            if (v2.y != v1.y) {
                v1.y = (1000.0 - v1.x) * (v2.y - v1.y) / (v2.x - v1.x) + v1.y;
            }
            v1.x = 1000.0;
        }
        if (v2.x < -1000.0) {
            if (v2.y != v1.y) {
                v2.y = (-1000.0 - v2.x) * (v1.y - v2.y) / (v1.x - v2.x) + v2.y;
            }
            v2.x = -1000.0;
        } else if (v2.x > 1000.0) {
            if (v2.y != v1.y) {
                v2.y = (1000.0 - v2.x) * (v1.y - v2.y) / (v1.x - v2.x) + v2.y;
            }
            v2.x = 1000.0;
        }
        if (v1.y < -1000.0) {
            if (v2.y != v1.y) {
                v1.x = (-1000.0 - v1.y) * (v2.x - v1.x) / (v2.y - v1.y) + v1.x;
            }
            v1.y = -1000.0;
        } else if (v1.y > 1000.0) {
            if (v2.y != v1.y) {
                v1.x = (1000.0 - v1.y) * (v2.x - v1.x) / (v2.y - v1.y) + v1.x;
            }
            v1.y = 1000.0;
        }
        if (v2.y < -1000.0) {
            if (v2.y != v1.y) {
                v2.x = (-1000.0 - v2.y) * (v1.x - v2.x) / (v1.y - v2.y) + v2.x;
            }
            v2.y = -1000.0;
        } else if (v2.y > 1000.0) {
            if (v2.y != v1.y) {
                v2.x = (1000.0 - v2.y) * (v1.x - v2.x) / (v1.y - v2.y) + v2.x;
            }
            v2.y = 1000.0;
        }
    }
}

