/*
 * Decompiled with CFR 0.152.
 */
package CaveRender;

class Spline {
    protected double[] pa;
    protected double[] pb;
    protected double[] pc;
    protected double[] pd;
    protected double[] x;
    protected int nSplines;
    protected boolean bPeriodisch;

    public Spline() {
    }

    public Spline(int n, boolean p) {
        this.Create(n, p);
    }

    public void Create(int n, boolean p) {
        this.nSplines = n;
        if (this.nSplines < 0) {
            this.nSplines = 0;
        }
        boolean bl = this.bPeriodisch = p && this.nSplines >= 3;
        if (this.bPeriodisch) {
            this.nSplines += 2;
        }
        this.pa = new double[this.nSplines];
        this.pb = new double[this.nSplines];
        this.pc = new double[this.nSplines];
        this.pd = new double[this.nSplines];
        this.x = new double[this.nSplines];
    }

    public void SetBases(double[] px, double[] py) {
        int n;
        double[] y = new double[this.nSplines];
        double[] h = new double[this.nSplines];
        double[] b = new double[this.nSplines];
        double[] v = new double[this.nSplines];
        double[] u = new double[this.nSplines];
        double[] m = new double[this.nSplines];
        double[] l = new double[this.nSplines];
        double[] q = new double[this.nSplines];
        double[] z = new double[this.nSplines];
        if (this.bPeriodisch) {
            int pSplines = this.nSplines - 2;
            this.x[0] = px[0] - px[pSplines - 1] + px[pSplines - 2];
            y[0] = py[0] - py[pSplines - 1] + py[pSplines - 2];
            n = 0;
            while (n < pSplines) {
                this.x[n + 1] = px[n];
                y[n + 1] = py[n];
                ++n;
            }
            this.x[this.nSplines - 1] = px[pSplines - 1] - px[0] + px[1];
            y[this.nSplines - 1] = py[pSplines - 1] - py[0] + py[1];
        } else {
            n = 0;
            while (n < this.nSplines) {
                this.x[n] = px[n];
                y[n] = py[n];
                ++n;
            }
        }
        n = 0;
        while (n < this.nSplines) {
            h[n] = 0.0;
            b[n] = 0.0;
            u[n] = 0.0;
            v[n] = 0.0;
            m[n] = 0.0;
            l[n] = 0.0;
            q[n] = 0.0;
            z[n] = 0.0;
            this.pa[n] = 0.0;
            this.pb[n] = 0.0;
            this.pc[n] = 0.0;
            this.pd[n] = 0.0;
            ++n;
        }
        n = 0;
        while (n < this.nSplines - 1) {
            h[n] = this.x[n + 1] - this.x[n];
            b[n] = (y[n + 1] - y[n]) / h[n];
            ++n;
        }
        n = 1;
        while (n < this.nSplines - 1) {
            u[n] = 2.0 * (h[n - 1] + h[n]);
            v[n] = 6.0 * (b[n] - b[n - 1]);
            ++n;
        }
        m[1] = u[1];
        n = 1;
        while (n < this.nSplines - 1) {
            l[n] = h[n] / m[n];
            m[n + 1] = u[n + 1] - l[n] * h[n];
            ++n;
        }
        q[1] = v[1];
        n = 2;
        while (n < this.nSplines - 1) {
            q[n] = v[n] - l[n - 1] * q[n - 1];
            ++n;
        }
        z[this.nSplines - 1] = q[this.nSplines - 1] / m[this.nSplines - 1];
        n = this.nSplines - 2;
        while (n > 0) {
            z[n] = (q[n] - h[n] * z[n + 1]) / m[n];
            --n;
        }
        n = 0;
        while (n < this.nSplines - 1) {
            this.pa[n] = (z[n + 1] - z[n]) / 6.0 / h[n];
            this.pb[n] = z[n] / 2.0;
            this.pc[n] = (y[n + 1] - y[n]) / h[n] - h[n] / 6.0 * (z[n + 1] + 2.0 * z[n]);
            this.pd[n] = y[n];
            ++n;
        }
    }

    public double GetValue(double xx) {
        double y = 0.0;
        int n = 0;
        if (xx >= this.x[0] && xx <= this.x[this.nSplines - 1]) {
            while (n < this.nSplines - 1 && this.x[n + 1] <= xx) {
                ++n;
            }
            if (xx == this.x[this.nSplines - 1]) {
                --n;
            }
            double dx = xx - this.x[n];
            y = this.pa[n] * dx * dx * dx + this.pb[n] * dx * dx + this.pc[n] * dx + this.pd[n];
        }
        return y;
    }
}

